
PreviewSlideArea.prototype = new AreaBase();
function PreviewSlideArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);

	this.ChangeImage = function(imageSrc)
	{
		this.Debug("ChangeImage: imageSrc = " + imageSrc);
		this.ImageUpdater.ChangeImage(imageSrc);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.InitializeImageUpdater();
		this.LoadPreviewImage();
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.InitializeImageUpdater = function()
	{
		this.Debug("InitializeImageUpdater called");
		
		var imageElement = this.GetCurrentImage();
		if (imageElement == null)
		{
			this.Debug("Could not find ImageElement in document");
			return;
		}
		
		this.ImageUpdater = new ImageUpdater(
			this.Container + ".ImageUpdater", 
			this.ContainingWindow,
			imageElement,
			0,
			0);
			
	}
	
	this.LoadPreviewImage = function()
	{
		this.Debug("LoadPreviewImage called");
		var areaManager = GetAreaManager();
		if (!areaManager)
		{
			alert('could not find areamanager');
			return;
		}
		
		var slideSorterArea = areaManager.GetArea(AreaNames.SlideSorterArea);
		if (!slideSorterArea)
		{
			alert('could not find SlideSorterArea');
			return;
		}
		
		this.ChangeImage(slideSorterArea.CurrentPreviewImage);
	}
	
	this.GetCurrentImage = function()
	{
		var image = SfDOM.FindElementFromID(document, "MyImage");
		return image;
	}
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PreviewSlideArea: " + msg);
	}
}

var PreviewSlideAreaInstance = new PreviewSlideArea("PreviewSlideAreaInstance", window, AreaNames.PreviewSlideArea);